;[]-----------------------------------------------------------------[]
;|   STRCPY.ASM -- copy string src to string dest                    |
;[]-----------------------------------------------------------------[]

;
;       C/C++ Run Time Library - Version 12.0
; 
;       Copyright (c) 1991, 2005 by Borland Software Corporation
;       All Rights Reserved.
; 

; $Revision: 9.7 $

        include RULES.ASI

;       Segments Definitions

Header@

;-----------------------------------------------------------------------
;
;Name           strcpy - copy string src to string dest
;
;Usage          char *strcpy (char *dest, const char *src);
;
;Prototype in   string.h
;
;Description    Copy the ASCIIZ string *src to  the buffer *dest. It is the
;               callers responsibility  to ensure that  the dest buffer  is
;               large enough  to contain the  string, and to  guard against
;               supplying NULL arguments.
;
;Return value   strcpy returns dest.
;
;-----------------------------------------------------------------------

Code_seg@

Func@   strcpy, _EXPFUNC, _RTLENTRYF, <pointer dest>, <pointer src>
        Link@   esi,edi
        mov     edi,src         ; get source string
        mov     esi,edi         ; copy to esi and edi
        mov     ecx,-1
        xor     al,al           ; search for null at end of source string
        cld
        repne   scasb           ; scan one character past null
        not     ecx             ; ecx = no. of characters including null
        mov     edi,dest        ; get destination buffer
        mov     eax,edi         ; copy to eax for return value
        mov     edx,ecx         ; save count
        shr     ecx,1           ; calculate longword count
        shr     ecx,1
        cld
        rep     movsd           ; copy longwords
        mov     ecx,edx         ; get back count
        and     ecx,3           ; calculate remainder byte count (0-3)
        rep     movsb           ; copy remaining bytes

        Unlink@ esi,edi
        Return@

EndFunc@ strcpy

_EXPFUNC __rtl_strcpy
__rtl_strcpy label near
        jmp _strcpy
        
;
;  Towards the end of the DeXter release (Borland C++Builder 2006), we found that
;  the visibroker libs had references to the symbol below (npos).  There was a late
;  bug fix to make this value be defined inline, and it didn't get there in time
;  to help the visibroker libs, apparently.  So I put in this terrible hack to
;  provide a definition for the symbol in the RTL DLL.  This should be removed
;  in the next release.
;
_EXPFUNC @std@%basic_string$c19std@%char_traits$c%17std@%allocator$c%%@npos
@std@%basic_string$c19std@%char_traits$c%17std@%allocator$c%%@npos label near
        dd -1

Code_EndS@

; used by the RTL to revector std::strcpy to our definition here.  Which means,
; sadly, that using std::strcpy prevents you from getting the intrinsic.
;alias <__rtl_strcpy>       = <_strcpy>
        
        end

